from enum import StrEnum, unique


@unique
class ComparisonOperator(StrEnum):
    EQ = '='
    EQUIV = '=='
    NE = '!='
    LT = '<'
    LE = '<='
    GE = '>='
    GT = '>'
    IN = 'in'
    NOT_IN = 'not_in'
    NOT = 'not'
    IS_NULL = 'is_null'
    IS_NOT_NULL = 'is_not_null'
    LIKE = 'like'
    ILIKE = 'ilike'


OPERATOR_MAP: dict[ComparisonOperator, str] = {
    ComparisonOperator.EQ: "eq",
    ComparisonOperator.EQUIV: "eq",
    ComparisonOperator.NE: "ne",
    ComparisonOperator.LT: "lt",
    ComparisonOperator.LE: "le",
    ComparisonOperator.GE: "ge",
    ComparisonOperator.GT: "gt",
    ComparisonOperator.IN: "in",
    ComparisonOperator.NOT: "not",
    ComparisonOperator.IS_NULL: "is_null",
    ComparisonOperator.IS_NOT_NULL: "is_not_null",
    ComparisonOperator.LIKE: "like",
    ComparisonOperator.ILIKE: "ilike",
    ComparisonOperator.NOT_IN: "not_in",
}
