# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from ai_assistant_server_connector.models.ai_assistant_goal_get import AiAssistantGoalGet
from ai_assistant_server_connector.models.conversation_style import ConversationStyle

class AiAssistantGet(BaseModel):
    """
    AiAssistantGet
    """
    id: StrictInt = Field(...)
    conversation_style: ConversationStyle = Field(...)
    avatar_id: Optional[StrictStr] = None
    voice_id: StrictInt = Field(...)
    name: StrictStr = Field(...)
    allow_text: StrictBool = Field(...)
    allow_voice: StrictBool = Field(...)
    system_prompt: Optional[StrictStr] = None
    conversation_starter: Optional[StrictStr] = None
    created_at: StrictInt = Field(...)
    last_updated_at: StrictInt = Field(...)
    deleted_at: Optional[StrictInt] = None
    goals: Optional[conlist(AiAssistantGoalGet)] = None
    __properties = ["id", "conversation_style", "avatar_id", "voice_id", "name", "allow_text", "allow_voice", "system_prompt", "conversation_starter", "created_at", "last_updated_at", "deleted_at", "goals"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AiAssistantGet:
        """Create an instance of AiAssistantGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in goals (list)
        _items = []
        if self.goals:
            for _item in self.goals:
                if _item:
                    _items.append(_item.to_dict())
            _dict['goals'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AiAssistantGet:
        """Create an instance of AiAssistantGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AiAssistantGet.parse_obj(obj)

        _obj = AiAssistantGet.parse_obj({
            "id": obj.get("id"),
            "conversation_style": obj.get("conversation_style"),
            "avatar_id": obj.get("avatar_id"),
            "voice_id": obj.get("voice_id"),
            "name": obj.get("name"),
            "allow_text": obj.get("allow_text"),
            "allow_voice": obj.get("allow_voice"),
            "system_prompt": obj.get("system_prompt"),
            "conversation_starter": obj.get("conversation_starter"),
            "created_at": obj.get("created_at"),
            "last_updated_at": obj.get("last_updated_at"),
            "deleted_at": obj.get("deleted_at"),
            "goals": [AiAssistantGoalGet.from_dict(_item) for _item in obj.get("goals")] if obj.get("goals") is not None else None
        })
        return _obj


