# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from ai_assistant_server_connector.models.search_result import SearchResult

class ResponseWrapperListSearchResult(BaseModel):
    """
    ResponseWrapperListSearchResult
    """
    done: StrictBool = Field(...)
    result: Optional[conlist(SearchResult)] = None
    error: Optional[StrictStr] = None
    __properties = ["done", "result", "error"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResponseWrapperListSearchResult:
        """Create an instance of ResponseWrapperListSearchResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in result (list)
        _items = []
        if self.result:
            for _item in self.result:
                if _item:
                    _items.append(_item.to_dict())
            _dict['result'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResponseWrapperListSearchResult:
        """Create an instance of ResponseWrapperListSearchResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ResponseWrapperListSearchResult.parse_obj(obj)

        _obj = ResponseWrapperListSearchResult.parse_obj({
            "done": obj.get("done"),
            "result": [SearchResult.from_dict(_item) for _item in obj.get("result")] if obj.get("result") is not None else None,
            "error": obj.get("error")
        })
        return _obj


