# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, conlist

class AiAssistantGoalCreate(BaseModel):
    """
    AiAssistantGoalCreate
    """
    is_active: StrictBool = Field(...)
    engagement: conint(strict=True, le=100, ge=0) = Field(...)
    name: StrictStr = Field(...)
    page_url: Optional[StrictStr] = None
    course_ids: Optional[conlist(StrictInt)] = None
    additional_prompt: StrictStr = Field(...)
    __properties = ["is_active", "engagement", "name", "page_url", "course_ids", "additional_prompt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AiAssistantGoalCreate:
        """Create an instance of AiAssistantGoalCreate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AiAssistantGoalCreate:
        """Create an instance of AiAssistantGoalCreate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AiAssistantGoalCreate.parse_obj(obj)

        _obj = AiAssistantGoalCreate.parse_obj({
            "is_active": obj.get("is_active"),
            "engagement": obj.get("engagement"),
            "name": obj.get("name"),
            "page_url": obj.get("page_url"),
            "course_ids": obj.get("course_ids"),
            "additional_prompt": obj.get("additional_prompt")
        })
        return _obj


