# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from pydantic import StrictInt, conlist

from typing import Any, Optional

from ai_assistant_server_connector.models.ai_assistant_reponse_stream_request import AIAssistantReponseStreamRequest
from ai_assistant_server_connector.models.ai_assistant_new import AiAssistantNew
from ai_assistant_server_connector.models.ai_assistant_update import AiAssistantUpdate
from ai_assistant_server_connector.models.response_wrapper_ai_assistant_session_start import ResponseWrapperAIAssistantSessionStart
from ai_assistant_server_connector.models.response_wrapper_ai_assistant_get import ResponseWrapperAiAssistantGet
from ai_assistant_server_connector.models.response_wrapper_bool import ResponseWrapperBool
from ai_assistant_server_connector.models.response_wrapper_int import ResponseWrapperInt
from ai_assistant_server_connector.models.response_wrapper_list_ai_assistant_goal_get import ResponseWrapperListAiAssistantGoalGet
from ai_assistant_server_connector.models.response_wrapper_list_ai_assistant_list_get import ResponseWrapperListAiAssistantListGet
from ai_assistant_server_connector.models.user_goal_interaction_create import UserGoalInteractionCreate

from ai_assistant_server_connector.api_client import ApiClient
from ai_assistant_server_connector.api_response import ApiResponse
from ai_assistant_server_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AssistantsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def ai_assistant_api_assistant_add(self, ai_assistant_new : AiAssistantNew, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Assistant Add  # noqa: E501


        :param ai_assistant_new: (required)
        :type ai_assistant_new: AiAssistantNew
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_add_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_add_with_http_info(ai_assistant_new, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_add_with_http_info(self, ai_assistant_new : AiAssistantNew, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Add  # noqa: E501


        :param ai_assistant_new: (required)
        :type ai_assistant_new: AiAssistantNew
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ai_assistant_new'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_add" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['ai_assistant_new'] is not None:
            _body_params = _params['ai_assistant_new']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_delete(self, assistant_id : StrictInt, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Assistant Delete  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_delete_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_delete_with_http_info(assistant_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_delete_with_http_info(self, assistant_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Delete  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'assistant_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_delete" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['assistant_id'] is not None:
            _path_params['assistant_id'] = _params['assistant_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/{assistant_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_get(self, assistant_id : StrictInt, **kwargs) -> ResponseWrapperAiAssistantGet:  # noqa: E501
        """Assistant Get  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperAiAssistantGet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_get_with_http_info(assistant_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_get_with_http_info(self, assistant_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Get  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperAiAssistantGet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'assistant_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['assistant_id'] is not None:
            _path_params['assistant_id'] = _params['assistant_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperAiAssistantGet",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/{assistant_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_primary_get(self, **kwargs) -> ResponseWrapperAiAssistantGet:  # noqa: E501
        """Assistant Primary Get  # noqa: E501


        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperAiAssistantGet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_primary_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_primary_get_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_primary_get_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Primary Get  # noqa: E501


        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperAiAssistantGet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_primary_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperAiAssistantGet",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
        }

        return await self.api_client.call_api(
            '/assistants/v1/primary', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_primary_goals_engagement_add(self, user_goal_interaction_create : UserGoalInteractionCreate, **kwargs) -> ResponseWrapperInt:  # noqa: E501
        """Assistant Primary Goals Engagement Add  # noqa: E501


        :param user_goal_interaction_create: (required)
        :type user_goal_interaction_create: UserGoalInteractionCreate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperInt
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_primary_goals_engagement_add_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_primary_goals_engagement_add_with_http_info(user_goal_interaction_create, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_primary_goals_engagement_add_with_http_info(self, user_goal_interaction_create : UserGoalInteractionCreate, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Primary Goals Engagement Add  # noqa: E501


        :param user_goal_interaction_create: (required)
        :type user_goal_interaction_create: UserGoalInteractionCreate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperInt, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_goal_interaction_create'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_primary_goals_engagement_add" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['user_goal_interaction_create'] is not None:
            _body_params = _params['user_goal_interaction_create']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperInt",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/primary/engagement', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_primary_goals_get(self, ids : Optional[conlist(StrictInt)] = None, **kwargs) -> ResponseWrapperListAiAssistantGoalGet:  # noqa: E501
        """Assistant Primary Goals Get  # noqa: E501


        :param ids:
        :type ids: List[int]
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListAiAssistantGoalGet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_primary_goals_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_primary_goals_get_with_http_info(ids, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_primary_goals_get_with_http_info(self, ids : Optional[conlist(StrictInt)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Primary Goals Get  # noqa: E501


        :param ids:
        :type ids: List[int]
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListAiAssistantGoalGet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ids'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_primary_goals_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
            _collection_formats['ids'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListAiAssistantGoalGet",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/primary/goals', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_primary_update(self, ai_assistant_update : AiAssistantUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Assistant Primary Update  # noqa: E501


        :param ai_assistant_update: (required)
        :type ai_assistant_update: AiAssistantUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_primary_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_primary_update_with_http_info(ai_assistant_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_primary_update_with_http_info(self, ai_assistant_update : AiAssistantUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Primary Update  # noqa: E501


        :param ai_assistant_update: (required)
        :type ai_assistant_update: AiAssistantUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ai_assistant_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_primary_update" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['ai_assistant_update'] is not None:
            _body_params = _params['ai_assistant_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/primary', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_response_stream(self, assistant_id : StrictInt, ai_assistant_reponse_stream_request : AIAssistantReponseStreamRequest, **kwargs) -> object:  # noqa: E501
        """Assistant Response Stream  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param ai_assistant_reponse_stream_request: (required)
        :type ai_assistant_reponse_stream_request: AIAssistantReponseStreamRequest
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_response_stream_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_response_stream_with_http_info(assistant_id, ai_assistant_reponse_stream_request, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_response_stream_with_http_info(self, assistant_id : StrictInt, ai_assistant_reponse_stream_request : AIAssistantReponseStreamRequest, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Response Stream  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param ai_assistant_reponse_stream_request: (required)
        :type ai_assistant_reponse_stream_request: AIAssistantReponseStreamRequest
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'assistant_id',
            'ai_assistant_reponse_stream_request'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_response_stream" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['assistant_id'] is not None:
            _path_params['assistant_id'] = _params['assistant_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['ai_assistant_reponse_stream_request'] is not None:
            _body_params = _params['ai_assistant_reponse_stream_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'schema', 'application/x-ndjson'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "object",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/{assistant_id}/response/stream', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_session_start(self, assistant_id : StrictInt, **kwargs) -> ResponseWrapperAIAssistantSessionStart:  # noqa: E501
        """Assistant Session Start  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperAIAssistantSessionStart
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_session_start_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_session_start_with_http_info(assistant_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_session_start_with_http_info(self, assistant_id : StrictInt, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Session Start  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperAIAssistantSessionStart, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'assistant_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_session_start" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['assistant_id'] is not None:
            _path_params['assistant_id'] = _params['assistant_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperAIAssistantSessionStart",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/{assistant_id}/session/start', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_shared_primary_get(self, **kwargs) -> ResponseWrapperAiAssistantGet:  # noqa: E501
        """Assistant Shared Primary Get  # noqa: E501


        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperAiAssistantGet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_shared_primary_get_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_shared_primary_get_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_shared_primary_get_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Shared Primary Get  # noqa: E501


        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperAiAssistantGet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_shared_primary_get" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperAiAssistantGet",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
        }

        return await self.api_client.call_api(
            '/assistants/v1/shared/primary', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_shared_primary_update(self, ai_assistant_update : AiAssistantUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Assistant Shared Primary Update  # noqa: E501


        :param ai_assistant_update: (required)
        :type ai_assistant_update: AiAssistantUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_shared_primary_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_shared_primary_update_with_http_info(ai_assistant_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_shared_primary_update_with_http_info(self, ai_assistant_update : AiAssistantUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Shared Primary Update  # noqa: E501


        :param ai_assistant_update: (required)
        :type ai_assistant_update: AiAssistantUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'ai_assistant_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_shared_primary_update" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['ai_assistant_update'] is not None:
            _body_params = _params['ai_assistant_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/shared/primary', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assistant_update(self, assistant_id : StrictInt, ai_assistant_update : AiAssistantUpdate, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Assistant Update  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param ai_assistant_update: (required)
        :type ai_assistant_update: AiAssistantUpdate
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assistant_update_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assistant_update_with_http_info(assistant_id, ai_assistant_update, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assistant_update_with_http_info(self, assistant_id : StrictInt, ai_assistant_update : AiAssistantUpdate, **kwargs) -> ApiResponse:  # noqa: E501
        """Assistant Update  # noqa: E501


        :param assistant_id: (required)
        :type assistant_id: int
        :param ai_assistant_update: (required)
        :type ai_assistant_update: AiAssistantUpdate
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'assistant_id',
            'ai_assistant_update'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assistant_update" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['assistant_id'] is not None:
            _path_params['assistant_id'] = _params['assistant_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['ai_assistant_update'] is not None:
            _body_params = _params['ai_assistant_update']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/{assistant_id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def ai_assistant_api_assitants_list(self, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, ids : Optional[conlist(StrictInt)] = None, **kwargs) -> ResponseWrapperListAiAssistantListGet:  # noqa: E501
        """Assitants List  # noqa: E501


        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param ids:
        :type ids: List[int]
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperListAiAssistantListGet
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the ai_assistant_api_assitants_list_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.ai_assistant_api_assitants_list_with_http_info(limit, offset, ids, **kwargs)  # noqa: E501

    @validate_arguments
    async def ai_assistant_api_assitants_list_with_http_info(self, limit : Optional[StrictInt] = None, offset : Optional[StrictInt] = None, ids : Optional[conlist(StrictInt)] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Assitants List  # noqa: E501


        :param limit:
        :type limit: int
        :param offset:
        :type offset: int
        :param ids:
        :type ids: List[int]
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperListAiAssistantListGet, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'offset',
            'ids'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ai_assistant_api_assitants_list" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('ids') is not None:  # noqa: E501
            _query_params.append(('ids', _params['ids']))
            _collection_formats['ids'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperListAiAssistantListGet",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/assistants/v1/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
