# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, conlist

class AiAssistantGoalCreateUpdate(BaseModel):
    """
    AiAssistantGoalCreateUpdate
    """
    is_active: StrictBool = Field(...)
    engagement_preset_id: Optional[StrictInt] = None
    engagement: Optional[conint(strict=True, le=100, ge=0)] = 50
    max_total_engagement_count: Optional[conint(strict=True, ge=0)] = 0
    max_engagement_count: Optional[conint(strict=True, ge=0)] = 0
    max_engagement_period: Optional[conint(strict=True, ge=0)] = 0
    engagement_opt_out_duration: Optional[conint(strict=True, ge=0)] = 0
    name: StrictStr = Field(...)
    page_url: Optional[StrictStr] = None
    primary_course_id: Optional[StrictInt] = None
    course_ids: conlist(StrictInt) = Field(...)
    additional_prompt: StrictStr = Field(...)
    id: Optional[StrictInt] = None
    __properties = ["is_active", "engagement_preset_id", "engagement", "max_total_engagement_count", "max_engagement_count", "max_engagement_period", "engagement_opt_out_duration", "name", "page_url", "primary_course_id", "course_ids", "additional_prompt", "id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AiAssistantGoalCreateUpdate:
        """Create an instance of AiAssistantGoalCreateUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AiAssistantGoalCreateUpdate:
        """Create an instance of AiAssistantGoalCreateUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AiAssistantGoalCreateUpdate.parse_obj(obj)

        _obj = AiAssistantGoalCreateUpdate.parse_obj({
            "is_active": obj.get("is_active"),
            "engagement_preset_id": obj.get("engagement_preset_id"),
            "engagement": obj.get("engagement") if obj.get("engagement") is not None else 50,
            "max_total_engagement_count": obj.get("max_total_engagement_count") if obj.get("max_total_engagement_count") is not None else 0,
            "max_engagement_count": obj.get("max_engagement_count") if obj.get("max_engagement_count") is not None else 0,
            "max_engagement_period": obj.get("max_engagement_period") if obj.get("max_engagement_period") is not None else 0,
            "engagement_opt_out_duration": obj.get("engagement_opt_out_duration") if obj.get("engagement_opt_out_duration") is not None else 0,
            "name": obj.get("name"),
            "page_url": obj.get("page_url"),
            "primary_course_id": obj.get("primary_course_id"),
            "course_ids": obj.get("course_ids"),
            "additional_prompt": obj.get("additional_prompt"),
            "id": obj.get("id")
        })
        return _obj


