# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from ai_assistant_server_connector.models.search_result import SearchResult

class RagQueryResponse(BaseModel):
    """
    RagQueryResponse
    """
    owned: conlist(SearchResult) = Field(...)
    available_free: conlist(SearchResult) = Field(...)
    available_paid: conlist(SearchResult) = Field(...)
    __properties = ["owned", "available_free", "available_paid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RagQueryResponse:
        """Create an instance of RagQueryResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in owned (list)
        _items = []
        if self.owned:
            for _item in self.owned:
                if _item:
                    _items.append(_item.to_dict())
            _dict['owned'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in available_free (list)
        _items = []
        if self.available_free:
            for _item in self.available_free:
                if _item:
                    _items.append(_item.to_dict())
            _dict['available_free'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in available_paid (list)
        _items = []
        if self.available_paid:
            for _item in self.available_paid:
                if _item:
                    _items.append(_item.to_dict())
            _dict['available_paid'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RagQueryResponse:
        """Create an instance of RagQueryResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RagQueryResponse.parse_obj(obj)

        _obj = RagQueryResponse.parse_obj({
            "owned": [SearchResult.from_dict(_item) for _item in obj.get("owned")] if obj.get("owned") is not None else None,
            "available_free": [SearchResult.from_dict(_item) for _item in obj.get("available_free")] if obj.get("available_free") is not None else None,
            "available_paid": [SearchResult.from_dict(_item) for _item in obj.get("available_paid")] if obj.get("available_paid") is not None else None
        })
        return _obj


