# coding: utf-8

"""
    Mentortools

    Mentortools

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from apple_connector.models.in_app_purchase_type import InAppPurchaseType

class IAPCreateParams(BaseModel):
    """
    IAPCreateParams
    """
    key_id: StrictStr = Field(...)
    issuer_id: StrictStr = Field(...)
    private_key: StrictStr = Field(...)
    base_price: StrictInt = Field(...)
    bundle_id: StrictStr = Field(...)
    iap_name: StrictStr = Field(...)
    file_name: StrictStr = Field(...)
    image_url: StrictStr = Field(...)
    product_id: StrictStr = Field(...)
    localisation_name: StrictStr = Field(...)
    description: StrictStr = Field(...)
    iap_type: Optional[InAppPurchaseType] = None
    __properties = ["key_id", "issuer_id", "private_key", "base_price", "bundle_id", "iap_name", "file_name", "image_url", "product_id", "localisation_name", "description", "iap_type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IAPCreateParams:
        """Create an instance of IAPCreateParams from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IAPCreateParams:
        """Create an instance of IAPCreateParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IAPCreateParams.parse_obj(obj)

        _obj = IAPCreateParams.parse_obj({
            "key_id": obj.get("key_id"),
            "issuer_id": obj.get("issuer_id"),
            "private_key": obj.get("private_key"),
            "base_price": obj.get("base_price"),
            "bundle_id": obj.get("bundle_id"),
            "iap_name": obj.get("iap_name"),
            "file_name": obj.get("file_name"),
            "image_url": obj.get("image_url"),
            "product_id": obj.get("product_id"),
            "localisation_name": obj.get("localisation_name"),
            "description": obj.get("description"),
            "iap_type": obj.get("iap_type")
        })
        return _obj


