# apple-connector
Mentortools

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0+2140327319
- Generator version: 7.17.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import apple_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import apple_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import apple_connector
from apple_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = apple_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with apple_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = apple_connector.AppInfoApi(api_client)
    bundle_identifier = apple_connector.BundleIdentifier() # BundleIdentifier | 

    try:
        # Get App ID
        api_response = await api_instance.setup_api_get_app_id(bundle_identifier)
        print("The response of AppInfoApi->setup_api_get_app_id:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AppInfoApi->setup_api_get_app_id: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AppInfoApi* | [**setup_api_get_app_id**](docs/AppInfoApi.md#setup_api_get_app_id) | **POST** /v1/app_info/app_id | Get App ID
*AppInfoApi* | [**setup_api_get_app_versions**](docs/AppInfoApi.md#setup_api_get_app_versions) | **POST** /v1/app_info/app_versions | Get App Versions
*AppScreenshotsApi* | [**setup_api_update_screenshots**](docs/AppScreenshotsApi.md#setup_api_update_screenshots) | **POST** /v1/app_screenshots/screenshots | Update screenshots
*BundleIdApi* | [**setup_api_check_bundle_id**](docs/BundleIdApi.md#setup_api_check_bundle_id) | **POST** /v1/bundle_id/check_bundle_id | Check Bundle ID
*BundleIdApi* | [**setup_api_create_bundle_id**](docs/BundleIdApi.md#setup_api_create_bundle_id) | **POST** /v1/bundle_id/create_bundle_id | Create Bundle ID
*BundleIdApi* | [**setup_api_fix_bundle_id**](docs/BundleIdApi.md#setup_api_fix_bundle_id) | **PATCH** /v1/bundle_id/update_bundle_id | Fix Bundle ID
*DefaultApi* | [**default_metrics**](docs/DefaultApi.md#default_metrics) | **GET** /metrics | Metrics
*IapApi* | [**setup_api_list_iap**](docs/IapApi.md#setup_api_list_iap) | **POST** /v1/app_iap/iap_list | List IAPs
*IapApi* | [**setup_api_list_subscriptions**](docs/IapApi.md#setup_api_list_subscriptions) | **POST** /v1/app_iap/subscription_list | List subscriptions
*IapApi* | [**setup_api_update_urls**](docs/IapApi.md#setup_api_update_urls) | **PATCH** /v1/app_iap/product_sandbox_urls | Update IAP URLs
*ReviewsApi* | [**setup_api_create_review**](docs/ReviewsApi.md#setup_api_create_review) | **POST** /v1/reviews/create | Submit for review
*ReviewsApi* | [**setup_api_list_reviews**](docs/ReviewsApi.md#setup_api_list_reviews) | **POST** /v1/reviews/get_list | List reviews
*SetupApiApi* | [**setup_api_check_bundle_id**](docs/SetupApiApi.md#setup_api_check_bundle_id) | **POST** /v1/bundle_id/check_bundle_id | Check Bundle ID
*SetupApiApi* | [**setup_api_check_credential**](docs/SetupApiApi.md#setup_api_check_credential) | **POST** /v1/users/validate_credentials | Validate credentials
*SetupApiApi* | [**setup_api_create_bundle_id**](docs/SetupApiApi.md#setup_api_create_bundle_id) | **POST** /v1/bundle_id/create_bundle_id | Create Bundle ID
*SetupApiApi* | [**setup_api_create_review**](docs/SetupApiApi.md#setup_api_create_review) | **POST** /v1/reviews/create | Submit for review
*SetupApiApi* | [**setup_api_fill_app_information**](docs/SetupApiApi.md#setup_api_fill_app_information) | **PATCH** /v1/setup_app/setup_app | Fill app information
*SetupApiApi* | [**setup_api_fix_bundle_id**](docs/SetupApiApi.md#setup_api_fix_bundle_id) | **PATCH** /v1/bundle_id/update_bundle_id | Fix Bundle ID
*SetupApiApi* | [**setup_api_get_app_id**](docs/SetupApiApi.md#setup_api_get_app_id) | **POST** /v1/app_info/app_id | Get App ID
*SetupApiApi* | [**setup_api_get_app_versions**](docs/SetupApiApi.md#setup_api_get_app_versions) | **POST** /v1/app_info/app_versions | Get App Versions
*SetupApiApi* | [**setup_api_invite_service_account**](docs/SetupApiApi.md#setup_api_invite_service_account) | **POST** /v1/users/service_account | Invite service account
*SetupApiApi* | [**setup_api_list_iap**](docs/SetupApiApi.md#setup_api_list_iap) | **POST** /v1/app_iap/iap_list | List IAPs
*SetupApiApi* | [**setup_api_list_reviews**](docs/SetupApiApi.md#setup_api_list_reviews) | **POST** /v1/reviews/get_list | List reviews
*SetupApiApi* | [**setup_api_list_subscriptions**](docs/SetupApiApi.md#setup_api_list_subscriptions) | **POST** /v1/app_iap/subscription_list | List subscriptions
*SetupApiApi* | [**setup_api_update_screenshots**](docs/SetupApiApi.md#setup_api_update_screenshots) | **POST** /v1/app_screenshots/screenshots | Update screenshots
*SetupApiApi* | [**setup_api_update_urls**](docs/SetupApiApi.md#setup_api_update_urls) | **PATCH** /v1/app_iap/product_sandbox_urls | Update IAP URLs
*SetupAppApi* | [**setup_api_fill_app_information**](docs/SetupAppApi.md#setup_api_fill_app_information) | **PATCH** /v1/setup_app/setup_app | Fill app information
*UsersApi* | [**setup_api_check_credential**](docs/UsersApi.md#setup_api_check_credential) | **POST** /v1/users/validate_credentials | Validate credentials
*UsersApi* | [**setup_api_invite_service_account**](docs/UsersApi.md#setup_api_invite_service_account) | **POST** /v1/users/service_account | Invite service account


## Documentation For Models

 - [ASCCredentials](docs/ASCCredentials.md)
 - [AppScreenshotDisplayType](docs/AppScreenshotDisplayType.md)
 - [BundleCapabilities](docs/BundleCapabilities.md)
 - [BundleIdCapabilityType](docs/BundleIdCapabilityType.md)
 - [BundleIdentifier](docs/BundleIdentifier.md)
 - [ContentRightsDeclaration](docs/ContentRightsDeclaration.md)
 - [CreateBundleId](docs/CreateBundleId.md)
 - [CredentialsCheckResult](docs/CredentialsCheckResult.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [IAPCreateParams](docs/IAPCreateParams.md)
 - [IAPProduct](docs/IAPProduct.md)
 - [InAppPurchaseType](docs/InAppPurchaseType.md)
 - [ReleaseType](docs/ReleaseType.md)
 - [ResultAppId](docs/ResultAppId.md)
 - [ResultAppVersions](docs/ResultAppVersions.md)
 - [ResultBundleId](docs/ResultBundleId.md)
 - [ResultBundleIdCheck](docs/ResultBundleIdCheck.md)
 - [ResultIAPList](docs/ResultIAPList.md)
 - [ResultStatus](docs/ResultStatus.md)
 - [ReviewResultApp](docs/ReviewResultApp.md)
 - [ReviewResultIAP](docs/ReviewResultIAP.md)
 - [ReviewResultItems](docs/ReviewResultItems.md)
 - [ReviewStatusResult](docs/ReviewStatusResult.md)
 - [ReviewType](docs/ReviewType.md)
 - [ScreenshotSet](docs/ScreenshotSet.md)
 - [SetAppUpdateParams](docs/SetAppUpdateParams.md)
 - [SetupAppParams](docs/SetupAppParams.md)
 - [SubscriptionStatusUrlVersion](docs/SubscriptionStatusUrlVersion.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [Webhooks](docs/Webhooks.md)
 - [WrappedResponseCredentialsCheckResult](docs/WrappedResponseCredentialsCheckResult.md)
 - [WrappedResponseResultAppId](docs/WrappedResponseResultAppId.md)
 - [WrappedResponseResultAppVersions](docs/WrappedResponseResultAppVersions.md)
 - [WrappedResponseResultBundleId](docs/WrappedResponseResultBundleId.md)
 - [WrappedResponseResultBundleIdCheck](docs/WrappedResponseResultBundleIdCheck.md)
 - [WrappedResponseResultIAPList](docs/WrappedResponseResultIAPList.md)
 - [WrappedResponseResultStatus](docs/WrappedResponseResultStatus.md)
 - [WrappedResponseReviewStatusResult](docs/WrappedResponseReviewStatusResult.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




