#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import Any

from .recursive import do_recursive


class AsyncOnStart:
    async def _on_start(self) -> None:
        pass

    @staticmethod
    async def start_if_necessary(target: Any) -> None:
        await do_recursive(target, lambda x: x._on_start(), lambda x: isinstance(x, AsyncOnStart))
