#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from aiohttp.web_exceptions import HTTPUnauthorized
from http_tools import IncomingRequest

from .abstract_http import AbstractHttpActorProvider
from ..actor.abstract import AbstractActor
from ..actor.server import ServerActor
from ..token_resolver.abstract import AbstractTokenResolver


class ServerNameAndAuthorizationHeaderActorProvider(AbstractHttpActorProvider):
    @dataclass
    class Config:
        pass

    @dataclass
    class Context:
        token_resolver: AbstractTokenResolver

    def __init__(self, config: Config, context: Context):
        self.context = context
        self.config = config

    async def get_actor(self, incoming_request: IncomingRequest) -> AbstractActor:
        if server_name := incoming_request.metadata.header_name_to_value.get("server_name"):
            return ServerActor(id=server_name)

        if (authorization_value := incoming_request.metadata.header_name_to_value.get("Authorization")) is None:
            raise HTTPUnauthorized(reason='Missing Authorization header')
        authorization_value: str
        if not authorization_value.startswith("Bearer "):
            raise HTTPUnauthorized(reason="Only Bearer authorization is supported. Format: 'Bearer <secret>'")
        token: str = authorization_value.removeprefix("Bearer ")
        user_actor = await self.context.token_resolver.resolve(token)
        return user_actor
