#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from http_tools import AbmServiceConnector
from init_helpers.dict_to_dataclass import dict_to_dataclass

from ..actor.user import UserActor
from .abstract import AbstractTokenResolver


@dataclass
class _ResolverAnswer:
    id: int

    @dataclass
    class _Permissions:
        @dataclass
        class _ActionItem:
            action_id: str

        action_list: list[_ActionItem]
        region_list: list[int]

    permissions: _Permissions


class SafeRegionTokenResolver(AbstractTokenResolver):
    Config = AbmServiceConnector.Config
    Context = AbmServiceConnector.Context

    def __init__(self, config: Config, context: Context):
        self.context = context
        self.config = config
        self.connector = AbmServiceConnector(config, context)

    async def resolve(self, token: str) -> UserActor:
        raw_answer = await self.connector.post(path="", payload={"token": token})
        resolver_answer = dict_to_dataclass(raw_answer, _ResolverAnswer)
        actor = UserActor(
            id=resolver_answer.id, token=token, permission_scope_to_actions={
                'actions': {action.action_id for action in resolver_answer.permissions.action_list},
                'regions': set(resolver_answer.permissions.region_list),
            }
        )
        return actor
