#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Iterable

import sqlalchemy as sa
from alembic import op


def get_table_columns(table_name: str) -> list[str]:
    connection: sa.Connection = op.get_bind()
    query = sa.text(f"SELECT column_name FROM information_schema.columns WHERE table_name='{table_name}'")
    return list(connection.execute(query).scalars())


def check_columns_exist(table_name: str, columns: Iterable[sa.Column]) -> bool:
    return {col.name for col in columns} < set(get_table_columns(table_name))
