#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mikhail Mamrov <m.mamrov@abm-jsc.ru>
#
import time
from dataclasses import dataclass, field
from detector_connector import DetectorSettings


@dataclass(frozen=True)
class ImageBox:
    left_up_x_percentage: float
    left_up_y_percentage: float
    right_bottom_x_percentage: float
    right_bottom_y_percentage: float
    created_at: float = field(default_factory=time.time)


@dataclass(kw_only=True, frozen=True)
class PollutionSettings(DetectorSettings):
    ignored_image_boxes: list[ImageBox] = field(default_factory=list)
