# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from chat_server_connector.models.chat_member_get import ChatMemberGet
from chat_server_connector.models.chat_message import ChatMessage
from chat_server_connector.models.chat_type import ChatType

class ChatListGet(BaseModel):
    """
    ChatListGet
    """
    id: StrictInt = Field(...)
    uuid: StrictStr = Field(...)
    chat_type: ChatType = Field(...)
    avatar_id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    messaging_enabled: StrictBool = Field(...)
    permalink_enabled: StrictBool = Field(...)
    is_muted: Optional[StrictBool] = False
    created_at: StrictInt = Field(...)
    last_updated_at: StrictInt = Field(...)
    members: Optional[conlist(ChatMemberGet)] = None
    last_message: Optional[ChatMessage] = None
    unread_count: Optional[StrictInt] = 0
    __properties = ["id", "uuid", "chat_type", "avatar_id", "name", "description", "messaging_enabled", "permalink_enabled", "is_muted", "created_at", "last_updated_at", "members", "last_message", "unread_count"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatListGet:
        """Create an instance of ChatListGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in members (list)
        _items = []
        if self.members:
            for _item in self.members:
                if _item:
                    _items.append(_item.to_dict())
            _dict['members'] = _items
        # override the default output from pydantic by calling `to_dict()` of last_message
        if self.last_message:
            _dict['last_message'] = self.last_message.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatListGet:
        """Create an instance of ChatListGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatListGet.parse_obj(obj)

        _obj = ChatListGet.parse_obj({
            "id": obj.get("id"),
            "uuid": obj.get("uuid"),
            "chat_type": obj.get("chat_type"),
            "avatar_id": obj.get("avatar_id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "messaging_enabled": obj.get("messaging_enabled"),
            "permalink_enabled": obj.get("permalink_enabled"),
            "is_muted": obj.get("is_muted") if obj.get("is_muted") is not None else False,
            "created_at": obj.get("created_at"),
            "last_updated_at": obj.get("last_updated_at"),
            "members": [ChatMemberGet.from_dict(_item) for _item in obj.get("members")] if obj.get("members") is not None else None,
            "last_message": ChatMessage.from_dict(obj.get("last_message")) if obj.get("last_message") is not None else None,
            "unread_count": obj.get("unread_count") if obj.get("unread_count") is not None else 0
        })
        return _obj


