# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt
from chat_server_connector.models.ai_assistant_get import AiAssistantGet
from chat_server_connector.models.chat_member_role import ChatMemberRole
from chat_server_connector.models.contact import Contact

class ChatMemberGet(BaseModel):
    """
    ChatMemberGet
    """
    role: Optional[ChatMemberRole] = None
    user_id: Optional[StrictInt] = None
    bot_id: Optional[StrictInt] = None
    id: StrictInt = Field(...)
    chat_id: StrictInt = Field(...)
    added_at: StrictInt = Field(...)
    last_seen_at: Optional[StrictInt] = None
    is_removed: Optional[StrictBool] = False
    is_banned: Optional[StrictBool] = False
    is_muted: Optional[StrictBool] = False
    user: Optional[Contact] = None
    bot: Optional[AiAssistantGet] = None
    __properties = ["role", "user_id", "bot_id", "id", "chat_id", "added_at", "last_seen_at", "is_removed", "is_banned", "is_muted", "user", "bot"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatMemberGet:
        """Create an instance of ChatMemberGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bot
        if self.bot:
            _dict['bot'] = self.bot.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatMemberGet:
        """Create an instance of ChatMemberGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatMemberGet.parse_obj(obj)

        _obj = ChatMemberGet.parse_obj({
            "role": obj.get("role"),
            "user_id": obj.get("user_id"),
            "bot_id": obj.get("bot_id"),
            "id": obj.get("id"),
            "chat_id": obj.get("chat_id"),
            "added_at": obj.get("added_at"),
            "last_seen_at": obj.get("last_seen_at"),
            "is_removed": obj.get("is_removed") if obj.get("is_removed") is not None else False,
            "is_banned": obj.get("is_banned") if obj.get("is_banned") is not None else False,
            "is_muted": obj.get("is_muted") if obj.get("is_muted") is not None else False,
            "user": Contact.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "bot": AiAssistantGet.from_dict(obj.get("bot")) if obj.get("bot") is not None else None
        })
        return _obj


