# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic import Field, StrictInt, conlist

from typing import Optional

from chat_server_connector.models.response_wrapper_bool import ResponseWrapperBool

from chat_server_connector.api_client import ApiClient
from chat_server_connector.api_response import ApiResponse
from chat_server_connector.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AdminApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    async def chat_api_wipe_bots_from_cache(self, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Wipe Bots From Cache  # noqa: E501


        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the chat_api_wipe_bots_from_cache_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.chat_api_wipe_bots_from_cache_with_http_info(**kwargs)  # noqa: E501

    @validate_arguments
    async def chat_api_wipe_bots_from_cache_with_http_info(self, **kwargs) -> ApiResponse:  # noqa: E501
        """Wipe Bots From Cache  # noqa: E501


        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chat_api_wipe_bots_from_cache" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
        }

        return await self.api_client.call_api(
            '/admin/v1/bot/cache', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def chat_api_wipe_portal_community_settings_from_cache(self, portal_id : Annotated[StrictInt, Field(..., description="Portal ID to wipe cache for")], **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Wipe Portal Community Settings From Cache  # noqa: E501


        :param portal_id: Portal ID to wipe cache for (required)
        :type portal_id: int
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the chat_api_wipe_portal_community_settings_from_cache_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.chat_api_wipe_portal_community_settings_from_cache_with_http_info(portal_id, **kwargs)  # noqa: E501

    @validate_arguments
    async def chat_api_wipe_portal_community_settings_from_cache_with_http_info(self, portal_id : Annotated[StrictInt, Field(..., description="Portal ID to wipe cache for")], **kwargs) -> ApiResponse:  # noqa: E501
        """Wipe Portal Community Settings From Cache  # noqa: E501


        :param portal_id: Portal ID to wipe cache for (required)
        :type portal_id: int
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'portal_id'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chat_api_wipe_portal_community_settings_from_cache" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('portal_id') is not None:  # noqa: E501
            _query_params.append(('portal_id', _params['portal_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/admin/v1/portal_community_settings/cache', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    async def chat_api_wipe_portal_members_from_cache(self, portal_id : Annotated[StrictInt, Field(..., description="Portal ID to wipe cache for")], portal_member_ids : Annotated[Optional[conlist(StrictInt)], Field(description="List of portal member IDs to wipe from cache")] = None, **kwargs) -> ResponseWrapperBool:  # noqa: E501
        """Wipe Portal Members From Cache  # noqa: E501


        :param portal_id: Portal ID to wipe cache for (required)
        :type portal_id: int
        :param portal_member_ids: List of portal member IDs to wipe from cache
        :type portal_member_ids: List[int]
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResponseWrapperBool
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the chat_api_wipe_portal_members_from_cache_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return await self.chat_api_wipe_portal_members_from_cache_with_http_info(portal_id, portal_member_ids, **kwargs)  # noqa: E501

    @validate_arguments
    async def chat_api_wipe_portal_members_from_cache_with_http_info(self, portal_id : Annotated[StrictInt, Field(..., description="Portal ID to wipe cache for")], portal_member_ids : Annotated[Optional[conlist(StrictInt)], Field(description="List of portal member IDs to wipe from cache")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Wipe Portal Members From Cache  # noqa: E501


        :param portal_id: Portal ID to wipe cache for (required)
        :type portal_id: int
        :param portal_member_ids: List of portal member IDs to wipe from cache
        :type portal_member_ids: List[int]
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResponseWrapperBool, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'portal_id',
            'portal_member_ids'
        ]
        _all_params.extend(
            [
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chat_api_wipe_portal_members_from_cache" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('portal_id') is not None:  # noqa: E501
            _query_params.append(('portal_id', _params['portal_id']))

        if _params.get('portal_member_ids') is not None:  # noqa: E501
            _query_params.append(('portal_member_ids', _params['portal_member_ids']))
            _collection_formats['portal_member_ids'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['APIKeyHeader', 'HTTPBearer']  # noqa: E501

        _response_types_map = {
            '200': "ResponseWrapperBool",
            '500': "ResponseWrapper",
            '400': "ResponseWrapper",
            '401': "ResponseWrapper",
            '403': "ResponseWrapper",
            '404': "ResponseWrapper",
            '422': "HTTPValidationError",
        }

        return await self.api_client.call_api(
            '/admin/v1/portal_member/cache', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
