# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from chat_server_connector.models.chat_type import ChatType

class ChatNew(BaseModel):
    """
    ChatNew
    """
    chat_type: ChatType = Field(...)
    avatar_id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    messaging_enabled: Optional[StrictBool] = True
    permalink_enabled: Optional[StrictBool] = False
    add_members: Optional[conlist(StrictInt)] = None
    __properties = ["chat_type", "avatar_id", "name", "description", "messaging_enabled", "permalink_enabled", "add_members"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatNew:
        """Create an instance of ChatNew from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatNew:
        """Create an instance of ChatNew from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatNew.parse_obj(obj)

        _obj = ChatNew.parse_obj({
            "chat_type": obj.get("chat_type"),
            "avatar_id": obj.get("avatar_id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "messaging_enabled": obj.get("messaging_enabled") if obj.get("messaging_enabled") is not None else True,
            "permalink_enabled": obj.get("permalink_enabled") if obj.get("permalink_enabled") is not None else False,
            "add_members": obj.get("add_members")
        })
        return _obj


