# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from chat_server_connector.models.contact_address import ContactAddress
from chat_server_connector.models.role_enum import RoleEnum

class Contact(BaseModel):
    """
    Contact
    """
    id: StrictInt = Field(...)
    role: RoleEnum = Field(...)
    nickname: Optional[StrictStr] = None
    personal_description: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = None
    last_name: Optional[StrictStr] = None
    avatar_id: Optional[StrictStr] = None
    is_online: Optional[StrictBool] = False
    address: Optional[ContactAddress] = None
    phone_number: Optional[StrictStr] = None
    is_public_email: Optional[StrictBool] = False
    is_public_phone_number: Optional[StrictBool] = False
    is_public_city: Optional[StrictBool] = False
    is_public_country: Optional[StrictBool] = False
    email: Optional[StrictStr] = None
    __properties = ["id", "role", "nickname", "personal_description", "first_name", "last_name", "avatar_id", "is_online", "address", "phone_number", "is_public_email", "is_public_phone_number", "is_public_city", "is_public_country", "email"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Contact:
        """Create an instance of Contact from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Contact:
        """Create an instance of Contact from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Contact.parse_obj(obj)

        _obj = Contact.parse_obj({
            "id": obj.get("id"),
            "role": obj.get("role"),
            "nickname": obj.get("nickname"),
            "personal_description": obj.get("personal_description"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "avatar_id": obj.get("avatar_id"),
            "is_online": obj.get("is_online") if obj.get("is_online") is not None else False,
            "address": ContactAddress.from_dict(obj.get("address")) if obj.get("address") is not None else None,
            "phone_number": obj.get("phone_number"),
            "is_public_email": obj.get("is_public_email") if obj.get("is_public_email") is not None else False,
            "is_public_phone_number": obj.get("is_public_phone_number") if obj.get("is_public_phone_number") is not None else False,
            "is_public_city": obj.get("is_public_city") if obj.get("is_public_city") is not None else False,
            "is_public_country": obj.get("is_public_country") if obj.get("is_public_country") is not None else False,
            "email": obj.get("email")
        })
        return _obj


