from typing import Any, List, Iterable, Callable, Type, NoReturn


class TableEngine:
    def __init__(self, name: str = 'undefined', args: Iterable[Any] = None):
        if args is None:
            args = []
        self.name = name
        self.args = list(args)

    def get_engine_sql(self) -> str:
        sql = self.name
        if self.args:
            sql += f'({", ".join(self.args)})'
        return sql

    def preprocess_select_request(self, select: 'Select') -> NoReturn:
        ...

    def apply(self, table: Type['Table']) -> NoReturn:
        ...
