#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from typing import Any

from qpel_helper.expresions.base import AbstractFactory


class ColumnFactory(AbstractFactory):
    def __init__(self, entity_name: str, clickhouse_interface):
        self._entity_name = entity_name
        self._clickhouse_interface = clickhouse_interface

    def __getattr__(self, key: Any):
        if not isinstance(key, str):
            raise ValueError(f"Cannot create column from non string key: {key}")
        entity = self._clickhouse_interface.get_entity_by_name(self._entity_name)
        return entity.column_from_str(key)
