#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
import abc
from typing import Optional, Type

from .sqlable import Sqlable
from ..clickhouse_types import ClickHouseType


class Selectable(Sqlable, abc.ABC):

    def __init__(self,
                 clickhouse_type: Type[ClickHouseType],
                 nullable: bool = False,
                 name: Optional[str] = None,
                 ):
        self.name: Optional[str] = name
        self.clickhouse_type: Type[ClickHouseType] = clickhouse_type
        self.nullable: bool = nullable

    @abc.abstractmethod
    def to_selector(self) -> str:
        pass

    def to_sql(self):
        return self.name
