from dataclasses import dataclass

from .abstract.selectable import Selectable
from .abstract.sqlable import Sqlable
from ..utils.escape import escape


@dataclass
class Order(Sqlable):
    column: Selectable
    ascending: bool

    def to_sql(self):
        return f'{escape(self.column)} {"ASC" if self.ascending else "DESC"}'
