from datetime import date, datetime
from enum import Enum
from uuid import UUID


escape_chars_map = {
    "\b": "\\b",
    "\f": "\\f",
    "\r": "\\r",
    "\n": "\\n",
    "\t": "\\t",
    "\0": "\\0",
    "\a": "\\a",
    "\v": "\\v",
    "\\": "\\\\",
    "'": "\\'"
}


def escape(val):
    if val is None:
        return 'NULL'
    elif isinstance(val, datetime):
        return "'%s'" % val.strftime('%Y-%m-%d %H:%M:%S')
    elif isinstance(val, date):
        return "'%s'" % val.strftime('%Y-%m-%d')
    elif isinstance(val, str):
        return "%s" % ''.join(escape_chars_map.get(c, c) for c in val)
    elif isinstance(val, list):
        return "[%s]" % ', '.join(str(escape(x)) for x in val)
    elif isinstance(val, tuple):
        return "(%s)" % ', '.join(str(escape(x)) for x in val)
    elif isinstance(val, Enum):
        return escape(val.value)
    elif isinstance(val, UUID):
        return "'%s'" % str(val)
    else:
        return val
