from typing import Type, Collection, NoReturn

from .table_engine import TableEngine
from ..elements.column import Column
from ..elements.table import Table
from ..statements.select import Select


class ReplacingMergeTree(TableEngine):
    def __init__(self, version_column: Column):
        args = str(version_column)
        super().__init__('ReplacingMergeTree', [args])
        self.version_column = version_column

    def apply(self, table: Type[Table]) -> NoReturn:
        pass
        # columns: Collection[Column] = table.get_columns()
        # primary_columns = set(table.get_primary_keys())
        # version_column = self.version_column
        # for column in columns:
        #     if column not in primary_columns and column != version_column:
        #         column.select_key_wrapper = f"argMax({column.select_key_wrapper}, {version_column})"

    def preprocess_select_request(self, select: Select) -> NoReturn:
        pass
        # p_keys = list(select.table.get_primary_keys())
        # select.group_by = p_keys + [self.version_column] + (select.group_by if select.group_by else [])

    @staticmethod
    def construct_from_sql(table: Type['Table']) -> str:
        return table.get_name() + " FINAL"
