from dataclasses import dataclass
from typing import Any

from clickhouse_tools.elements.column import Column
from clickhouse_tools.elements.order import Order as ChOrder
from clickhouse_tools.qpel_helper.expresions.base import AbstractFactory
from clickhouse_tools.qpel_helper.expresions.functions.abstract_function import AbstractFunction

@dataclass
class OrderBy(AbstractFunction):

    def call(self, column: Column, asc: bool = True) -> ChOrder:
        return ChOrder(column, asc)


class SqlFactory(AbstractFactory):

    def __getattr__(self, key: Any):
        if not isinstance(key, str):
            raise ValueError(f"Cannot create column from non string key: {key}")
        if key != "order":
            raise NotImplementedError(f"only order by is implemented")

        return OrderBy(key)
