from dataclasses import dataclass
from typing import Type, NoReturn

from ..elements.table import Table
from ..statements.abstract_statement import AbstractStatement


@dataclass
class CreateTable(AbstractStatement):
    table: Type[Table]

    def generate_sql(self) -> str:
        table_name = self.table.get_name()

        table_column_descriptors = [column.to_column_descriptor() for column in self.table.get_columns()]
        table_columns_string = ', '.join(table_column_descriptors)

        engine_string = self.table.get_table_engine().get_engine_sql()

        table_partition_key_names = [column.to_partition_key_name() for column in self.table.get_primary_keys() if
                                     column.to_partition_key_name()]
        table_partition_keys_string = ''
        if table_partition_key_names:
            table_partition_keys_string = f"PARTITION BY ({', '.join(table_partition_key_names)}) \n"

        table_primary_keys_string = ', '.join(self.table.get_primary_key_names())

        create_string = f"CREATE TABLE IF NOT EXISTS {self.database}.{table_name}\n " \
                        f"(\n{table_columns_string}\n) " \
                        f"ENGINE = {engine_string} \n" \
                        f"{table_partition_keys_string}" \
                        f"ORDER BY ({table_primary_keys_string})"
        return create_string

    def form_result(self, payload: str) -> NoReturn:
        ...
