# data-cast-server-connector
Mentortools Course cast server

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.1.0+2163404978
- Generator version: 7.17.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import data_cast_server_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import data_cast_server_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import data_cast_server_connector
from data_cast_server_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = data_cast_server_connector.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: APIKeyHeader
configuration.api_key['APIKeyHeader'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['APIKeyHeader'] = 'Bearer'

# Configure Bearer authorization: HTTPBearer
configuration = data_cast_server_connector.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
async with data_cast_server_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = data_cast_server_connector.DataCastApiApi(api_client)
    portal_id = 56 # int | 

    try:
        # Index Get
        api_response = await api_instance.data_cast_api_index_get(portal_id)
        print("The response of DataCastApiApi->data_cast_api_index_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DataCastApiApi->data_cast_api_index_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataCastApiApi* | [**data_cast_api_index_get**](docs/DataCastApiApi.md#data_cast_api_index_get) | **GET** /portal_indexes/v1/{portal_id} | Index Get
*DataCastApiApi* | [**data_cast_api_index_self_start**](docs/DataCastApiApi.md#data_cast_api_index_self_start) | **POST** /portal_indexes/v1/self/start | Index Self Start
*DataCastApiApi* | [**data_cast_api_index_start**](docs/DataCastApiApi.md#data_cast_api_index_start) | **POST** /portal_indexes/v1/{portal_id}/start | Index Start
*DataCastApiApi* | [**data_cast_api_indexed_list**](docs/DataCastApiApi.md#data_cast_api_indexed_list) | **GET** /portal_indexes/v1/ | Indexed List
*DataCastApiApi* | [**data_cast_api_self_index_get**](docs/DataCastApiApi.md#data_cast_api_self_index_get) | **GET** /portal_indexes/v1/self | Self Index Get
*HealthApi* | [**health_health_check**](docs/HealthApi.md#health_health_check) | **GET** / | Health Check
*PortalIndexesApi* | [**data_cast_api_index_get**](docs/PortalIndexesApi.md#data_cast_api_index_get) | **GET** /portal_indexes/v1/{portal_id} | Index Get
*PortalIndexesApi* | [**data_cast_api_index_self_start**](docs/PortalIndexesApi.md#data_cast_api_index_self_start) | **POST** /portal_indexes/v1/self/start | Index Self Start
*PortalIndexesApi* | [**data_cast_api_index_start**](docs/PortalIndexesApi.md#data_cast_api_index_start) | **POST** /portal_indexes/v1/{portal_id}/start | Index Start
*PortalIndexesApi* | [**data_cast_api_indexed_list**](docs/PortalIndexesApi.md#data_cast_api_indexed_list) | **GET** /portal_indexes/v1/ | Indexed List
*PortalIndexesApi* | [**data_cast_api_self_index_get**](docs/PortalIndexesApi.md#data_cast_api_self_index_get) | **GET** /portal_indexes/v1/self | Self Index Get


## Documentation For Models

 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [PortalIndexInfoGet](docs/PortalIndexInfoGet.md)
 - [PortalIndexSource](docs/PortalIndexSource.md)
 - [PortalIndexStatus](docs/PortalIndexStatus.md)
 - [ResponseWrapper](docs/ResponseWrapper.md)
 - [ResponseWrapperBool](docs/ResponseWrapperBool.md)
 - [ResponseWrapperListPortalIndexInfoGet](docs/ResponseWrapperListPortalIndexInfoGet.md)
 - [ResponseWrapperPortalIndexInfoGet](docs/ResponseWrapperPortalIndexInfoGet.md)
 - [Result](docs/Result.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="HTTPBearer"></a>
### HTTPBearer

- **Type**: Bearer authentication

<a id="APIKeyHeader"></a>
### APIKeyHeader

- **Type**: API key
- **API key parameter name**: server_name
- **Location**: HTTP header


## Author




