#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Revva Konstantin <k.revva@abm-jsc.ru>

from dataclasses import dataclass
from typing import Any


@dataclass
class DefocusAnalyzeResult:
    rtsp_url: str
    snapshot_file_id: str
    snapshot_done_at: float
    reference_image_file_ids: list[str]
    detector_requests: list[dict[str, str | float | bool | int]]
    detector_results: list[dict[str, str | float | bool | int]]
    comparison_settings: dict[str, str | float]
    comparison_results: list[float]
    result: float
    analyzed_at: float
