#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Any


def _prepare_class_name(bases: list[type], modifier: Any) -> str:
    def split_by_brackets(class_string: str) -> list[str]:
        parts = class_string.split("[")
        return parts

    def remove_import_path(class_string: str) -> str:
        res = class_string.rsplit(".", 1)[-1]
        return res

    name_base = "".join(
        '_'.join(remove_import_path(part) for part in split_by_brackets(str(base)))
        for base in bases + [modifier]
    )
    name_base = name_base.replace("typing.", "")
    name_base = name_base.replace("class", "")
    name_base = "".join(char if char.isalnum() else "_" for char in name_base)
    result = ""
    is_next_char_upper = True
    for char in name_base:
        if char.isalnum():
            if is_next_char_upper:
                is_next_char_upper = False
                char = char.upper()
            result += char
        else:
            is_next_char_upper = True

    return result
