#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses
import functools
from typing import Iterable, Any

from .hashable_dict import HashableDict


@functools.cache
def _create_type(name: str, bases: list[type], parameter_name_to_value: dict[str, Any]) -> type:
    new_type = type(name, tuple(bases), parameter_name_to_value)
    return new_type


@functools.cache
def _create_dataclass(name: str, bases: list[type], parameter_name_to_type: dict[str, type]) -> type:
    new_type = type(name, tuple(bases), {name: None for name, type_ in parameter_name_to_type.items()})
    new_type.__annotations__ = parameter_name_to_type
    return new_type


def create_type(name: str, bases: Iterable[type], parameter_name_to_value: dict[str, Any]) -> type:
    return _create_type(name, tuple(bases), HashableDict(parameter_name_to_value))


def create_dataclass(name: str, bases: Iterable[type], parameter_name_to_type: dict[str, type]) -> type:
    new_type = _create_dataclass(name, tuple(bases), HashableDict(parameter_name_to_type))
    dataclass_ = dataclasses.dataclass(new_type)
    return dataclass_
