#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Iterable, Any, Callable


class Missing:
    pass


def create_function(
        name: str,
        args: Iterable[str],
        body: Iterable[str], *,
        globals_: dict[str, Any] | None = None,
        return_type: type | Missing = Missing
) -> Callable[..., Any]:
    locals_ = {}
    return_annotation = ''
    if return_type is not Missing:
        locals_['_return_type'] = return_type
        return_annotation = '->_return_type'
    args = ','.join(args)
    body = '\n'.join(f'  {b}' for b in body)

    # Compute the text of the entire function.
    txt = f' def {name}({args}){return_annotation}:\n{body}'

    local_vars = ', '.join(locals_.keys())
    txt = f"def __create_fn__({local_vars}):\n{txt}\n return {name}"
    ns: dict[str, Any] = {}
    exec(txt, globals_, ns)
    return ns['__create_fn__'](**locals_)
