#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses
import functools
from typing import Iterable, Any

from frozendict import frozendict


@functools.cache
def _create_type(name: str, bases: tuple[type, ...], parameter_name_to_value: frozendict[str, Any]) -> type:
    # noinspection PyTypeChecker
    return type(name, bases, parameter_name_to_value)


@functools.cache
def _create_dataclass(name: str, bases: tuple[type, ...], parameter_name_to_type: frozendict[str, type]) -> type:
    new_type = type(name, bases, {})
    new_type.__annotations__ = parameter_name_to_type
    # noinspection PyTypeChecker
    return dataclasses.dataclass(new_type)


def create_type(name: str, bases: Iterable[type], parameter_name_to_value: dict[str, Any]) -> type:
    return _create_type(name, tuple(bases), frozendict(parameter_name_to_value))


def create_dataclass(name: str, bases: Iterable[type], parameter_name_to_type: dict[str, type]) -> type:
    return _create_dataclass(name, tuple(bases), frozendict(parameter_name_to_type))
