#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>
import json
from functools import partial
from typing import Any


def convert_to_list(value: Any, element_type: type) -> list:
    if isinstance(value, str):
        try:
            value = json.loads(value)
        except ValueError:
            ...
    if not isinstance(value, list):
        value = [value]
    value = [element_type(val) for val in value]
    return value


convert_to_list_of_string = partial(convert_to_list, element_type=str)
convert_to_list_of_int = partial(convert_to_list, element_type=int)
