from sqlalchemy import Text, SmallInteger
from sqlalchemy_tools.entity_helpers.sqlalchemy_base import sqlalchemy_mapper_registry

from entity_view.components import sqlalchemy_dataclass
from entity_view.viewable_entity import ViewableEntity
from sql_field import sql_field


@sqlalchemy_dataclass(sqlalchemy_mapper_registry)
class InnerRequestToAccompanyingFile(ViewableEntity):
    __tablename__ = "inner_request_to_accompanying_file"
    request_id: int = sql_field(SmallInteger, primary_key=True, index=True, autoincrement=False, nullable=False)
    file_id: str = sql_field(Text, nullable=False)
