
from sqlalchemy import Boolean, BigInteger
from sqlalchemy_tools.entity_helpers.fk_keys import CascadeForeignKey
from sqlalchemy_tools.entity_helpers.sqlalchemy_base import sqlalchemy_mapper_registry

from entity_view.components import sqlalchemy_dataclass
from entity_view.viewable_entity import ViewableEntity
from sql_field import sql_field


@sqlalchemy_dataclass(sqlalchemy_mapper_registry)
class UserToOrganization(ViewableEntity):
    __tablename__ = "user_to_organization"

    organization_inn: int = sql_field(BigInteger, index=True, foreign_key=CascadeForeignKey("organization.inn"),
                                      primary_key=True, autoincrement=False)
    # organization_id: int = sql_field(BigInteger, index=True, foreign_key=CascadeForeignKey("organization.id"),
    #                                   primary_key=True, allow_init_primary_key=True)
    created_at: int = sql_field(
        BigInteger,
        nullable=False,
    )
    user_id: int = sql_field(BigInteger, primary_key=True, autoincrement=False, nullable=False)

    is_admin: int = sql_field(
        Boolean,
        nullable=False,
        default=False
    )


