#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import json
import pathlib
from dataclasses import dataclass, InitVar, field
from typing import Any


class TranslationLoader:
    @dataclass
    class Config:
        translation_files_location: InitVar[str] = "translation"
        translation_files_path: pathlib.Path = field(init=False)

        def __post_init__(self, translation_files_location: str) -> None:
            self.translation_files_path = pathlib.Path(translation_files_location)

    def __init__(self, config: Config):
        self.config = config

    async def get_translations_file_content(self, project: str, component: str, language: str) -> dict[str, Any]:
        file_path = self.config.translation_files_path / component / f'{language}.json'
        if not file_path.exists() or not file_path.is_file():
            raise KeyError(f"Missing translation file: {file_path.absolute()}")
        with file_path.open() as file:
            file_content = file.read()
        result = json.loads(file_content)
        return result
