#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import dataclass

from entity_read import sql
from entity_read.entity import Entity
from entity_read.sql.atoms import Selectable

from .query_token import QueryToken


@dataclass(frozen=True, kw_only=True, repr=False)
class Expression(QueryToken, abc.ABC):

    @abc.abstractmethod
    def eval(self, entity_type: type[Entity], variables: dict[str, Selectable]) -> sql.atoms.Selectable:
        pass


def as_(self, key: str):
    from .alias import Alias
    return Alias(body=self, key=key)


setattr(Expression, 'as', as_)
