#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from entity_read.sql.atoms.node import SQL
from .abstract import Selectable


@dataclass(kw_only=True, frozen=True)
class Column(Selectable):
    key: str

    def to_sql(self, context, key_to_expression: dict = None) -> SQL:
        key_to_expression = {} if key_to_expression is None else key_to_expression
        result = key_to_expression[self.key] if self.key in key_to_expression else f'{context.get_self()}."{self.key}"'
        return result

    def requires(self) -> list['Column']:
        return [self]

    def get_name(self) -> str:
        return self.key
