#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from dataclasses import dataclass

from .entity_server_connector import EntityServerConnector


class ServerNameEntityServerConnector(EntityServerConnector):

    @dataclass
    class SafeRegionConfig:
        server_name: str

    @dataclass
    class Config(EntityServerConnector.Config, SafeRegionConfig):
        pass

    Context = EntityServerConnector.Context

    def __init__(self, config: Config, context: Context) -> None:
        self._server_name = config.server_name
        super(ServerNameEntityServerConnector, self).__init__(config, context)

    def _construct_headers(self) -> dict[str, str]:
        headers = super(ServerNameEntityServerConnector, self)._construct_headers()
        headers["server_name"] = self._server_name
        return headers
