#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

# from ..node import NodeType
from ..node import Node
from .abstract import Selectable
from .column import EColumn


@dataclass
class EAlias(Selectable):
    # type = NodeType.alias
    value: Node
    alias: str

    def to_sql(self, context, key_to_expression = None) -> str:
        return self.value.to_sql(context, key_to_expression)

    def requires(self) -> list['EColumn']:
        return self.value.requires()

    def get_name(self) -> str:
        return self.alias
