#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import Field
from typing import TypeVar

from dynamic_types.class_name import _prepare_class_name

from .abstract import AbstractView
from ..entity import Entity

T = TypeVar("T")


class EntityView(AbstractView, abc.ABC):
    @classmethod
    def _produce_view(cls, entity_type: type[Entity]) -> type:
        if not isinstance(entity_type, type) or not issubclass(entity_type, Entity):
            raise TypeError(f'EntityView subscription requires type[Entity], got: {entity_type}')
        field_name_to_field = cls._produce_field_name_to_field(entity_type)
        class_name = _prepare_class_name([entity_type], cls)
        return cls._produce_child_dataclass(class_name, field_name_to_field)

    @classmethod
    @abc.abstractmethod
    def _produce_field_name_to_field(cls, entity_type: type[Entity]) -> dict[str, Field]:
        pass
