import dataclasses

from dict_caster.extras import first
from init_helpers import dict_to_dataclass
from sqlalchemy import select, and_, or_
from sqlalchemy_tools.database_connector.database_connector import DatabaseConnector

from entity_view.viewable_entity import FullView, InsertView, SelectedView, UpdateView
from extended_logger import get_logger
from proposal import EntityDatabase
from template.delta_view_weblate_renderer import DeltaViewWeblateRenderer
from entities.organization import Organization

logger = get_logger(__name__)


class Controller:
    @dataclasses.dataclass
    class Config:
        pass

    @dataclasses.dataclass
    class Context:
        organization_database: DatabaseConnector
        delta_view_renderer: DeltaViewWeblateRenderer
        entity_database: EntityDatabase

    def __init__(self, config: Config, context: Context):
        self.config = config
        self.context = context

    async def render_diff_from_db(self, organization: Organization):
        async with self.context.organization_database.get_session() as database_session:
            query = select(Organization)
            query = query.where(Organization.inn == organization.inn)
            existent_organization = first(list((await database_session.execute(query)).scalars()))
            # existent_organization = dict_to_dataclass(existent_organization, Organization[SelectedView])

            # return existent_organization

        # organization = dict_to_dataclass(organization, Organization[UpdateView])
        print(f"{existent_organization=}")
        print(f"{organization=}")

        delta = FullView.get_delta(existent_organization, organization)
        logger.trace(f"got {'non ' if delta.is_not_empty() else ''}empty delta {delta}")
        if delta and delta.is_not_empty():
            rendered_entity = self.context.delta_view_renderer.render(delta)
            return rendered_entity

    async def insert(self, organization: Organization):
        async with self.context.organization_database.get_session() as database_session:
            logger.debug(f"start insert cascade of {organization}")
            await self.context.entity_database.insert_cascade([organization], database_session)
            logger.debug(f"done insert cascade of {organization}")
            await database_session.commit()

    async def test_type(self, organization_type: type):
        pass
        # async with self.context.organization_database.get_session() as database_session:
        #     logger.debug(f"start insert cascade of {organization}")
        #     await self.context.entity_database.insert_cascade([organization], database_session)
        #     logger.debug(f"done insert cascade of {organization}")
        #     await database_session.commit()
