from sqlalchemy import BigInteger, Text
# from sqlalchemy_tools.entity_helpers.decorator import sqlalchemy_dataclass
# from sqlalchemy_tools.entity_helpers.fields import sql_field, sql_relation_field
from sqlalchemy.orm import mapped_column, Mapped, relationship
from sqlalchemy_tools.entity_helpers.sqlalchemy_base import sqlalchemy_mapper_registry

from entity_view.components import sqlalchemy_dataclass
from entity_view.viewable_entity import ViewableEntity, SelectedView
from sql_field import sql_field, sql_relation_field
from .user_to_organization import UserToOrganization
# from entity_view.components import sqlalchemy_dataclass


@sqlalchemy_dataclass(sqlalchemy_mapper_registry)
class Organization(ViewableEntity):
    __tablename__ = "organization"
    inn: int = sql_field(BigInteger, primary_key=True, index=True, autoincrement=False, nullable=False)
    ogrn: int = sql_field(BigInteger, nullable=False)
    chat_id: int = sql_field(BigInteger, nullable=False)
    created_at: int = sql_field(
        BigInteger,
        nullable=False,
    )
    title: str | None = sql_field(Text, nullable=False)
    address_city: str | None = sql_field(Text, nullable=False)
    users: list[UserToOrganization] = sql_relation_field(UserToOrganization, lazy="selectin")
    # id: int = sql_field(BigInteger, primary_key=True, index=True, nullable=False, allow_init_primary_key=True)
#
#
# # @sqlalchemy_dataclass(sqlalchemy_mapper_registry)
# @sqlalchemy_mapper_registry.mapped_as_dataclass
# class Organization(ViewableEntity):
#     __tablename__ = "organization"
#     inn: Mapped[int] = mapped_column(BigInteger, primary_key=True, index=True, allow_init_primary_key=True, nullable=False)
#     ogrn: Mapped[int] = mapped_column(BigInteger, nullable=False)
#     chat_id: Mapped[int] = mapped_column(BigInteger, nullable=False)
#     created_at: Mapped[int] = mapped_column(
#         BigInteger,
#         nullable=False,
#     )
#     title: Mapped[str | None] = mapped_column(Text, nullable=False)
#     address_city: Mapped[str | None] = mapped_column(Text, nullable=False)
#     users: list[UserToOrganization] = relationship(UserToOrganization, lazy="selectin", default_factory=list)
