#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from dataclasses import dataclass

from .connector import FileServerConnector

# TODO move BaseAuthConnector to http_tools


class BaseAuthFileServerConnector(FileServerConnector):
    @dataclass(kw_only=True)
    class Context(FileServerConnector.Context):
        project_name: str

    Config = FileServerConnector.Config

    def __init__(self, config: Config, context: Context) -> None:
        super(BaseAuthFileServerConnector, self).__init__(config, context)
        self._project_name = context.project_name

    def _construct_headers(self) -> dict[str, str]:
        headers = super(BaseAuthFileServerConnector, self)._construct_headers()
        headers["server_name"] = self._project_name
        return headers

