#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from dataclasses import dataclass

from .connector import LegacyFileServerConnector


class ServerNameLegacyFileServerConnector(LegacyFileServerConnector):
    # consider to move server name header somewhere else
    @dataclass
    class SafeRegionConfig:
        server_name: str

    @dataclass
    class Config(LegacyFileServerConnector.Config, SafeRegionConfig):
        pass

    Context = LegacyFileServerConnector.Context

    def __init__(self, config: Config, context: Context) -> None:
        self._server_name = config.server_name
        super(ServerNameLegacyFileServerConnector, self).__init__(config, context)

    def _construct_headers(self) -> dict[str, str]:
        headers = super(ServerNameLegacyFileServerConnector, self)._construct_headers()
        headers["server_name"] = self._server_name
        return headers
