#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>


import logging
from http_tools.http_server_connector import HttpServerConnector


logger = logging.getLogger(__name__)


class LegacyFileServerConnector:

    Config = HttpServerConnector.Config
    Context = HttpServerConnector.Context

    def __init__(self, config: Config, context: Context):
        self._config = config
        self._context = context
        self._connector = HttpServerConnector(config, context)

    async def get_file(self, file_id: int) -> bytes:
        args = {"id": file_id}
        return await self._connector.get("/file/get", args, headers=self._construct_headers())

    async def add_file(self, file: bytes, filename: str, path_prefix: str | None = None) -> dict:
        args = {"filename": filename}
        if path_prefix:
            args["path_prefix"] = path_prefix

        answer = await self._connector.post("/file/add", payload=file, url_query=args,
                                            headers=self._construct_headers())
        return answer["result"]

    async def delete_file(self, file_id: int) -> dict:
        args = {"id": file_id}
        answer = await self._connector.post("/file/delete", payload=None,
                                            url_query=args, headers=self._construct_headers())
        return answer["result"]

    def _construct_headers(self) -> dict[str, str]:
        headers = {"Connection": "Keep-Alive"}
        return headers
