#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

import logging
from dataclasses import dataclass

import aioboto3


logger = logging.getLogger(__name__)


class S3Connector:
    @dataclass
    class Config:
        access_key: str
        secret_key: str
        address: str = None
        region_name: str = "eu-north-1"

    def __init__(self, config: Config):
        logger.info(f"{type(self).__name__} init")
        self.region_name = config.region_name
        self._endpoint_url = config.address
        self._access_key = config.access_key
        self._secret_key = config.secret_key

    @property
    def session(self) -> aioboto3.session.ResourceCreatorContext:
        logger.debug("Create a resource service ...")
        session = aioboto3.Session()
        return session.resource(service_name='s3',
                                endpoint_url=self._endpoint_url,
                                region_name=self.region_name,
                                aws_access_key_id=self._access_key,
                                aws_secret_access_key=self._secret_key)
