#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

import hashlib
from typing import Union


def generate_md5_hash(payload: Union[bytes, str]) -> str:
    m = hashlib.md5()
    m.update(payload)
    return m.hexdigest()


def generate_sha512_hash(payload: Union[bytes, str]) -> str:
    m = hashlib.sha512()
    m.update(payload)
    return m.hexdigest()
