from pathlib import Path


def prepare_filename_with_extension(file_name: str, file_extension: str) -> str:
    return str(Path(file_name).with_suffix(file_extension))


def shorten_file_name_by_bytes_size(file_name: str, max_required_bytes_size: int) -> str:
    file_name_bytes_size = len(file_name.encode())

    if file_name_bytes_size <= max_required_bytes_size:
        return file_name

    file_name = Path(file_name)
    extension = file_name.suffix or ''
    extension_bytes_size = len(extension.encode())

    if max_required_bytes_size < extension_bytes_size:
        raise ValueError(f'required_bytes_size({max_required_bytes_size}) < extension_bytes_size({extension_bytes_size})')

    max_required_bytes_size = max_required_bytes_size - extension_bytes_size

    result = ''

    for symbol in file_name.stem:
        result_bytes_size = len(result.encode())
        last_symbol_bytes_size = len(symbol.encode())

        if result_bytes_size + last_symbol_bytes_size > max_required_bytes_size:
            break

        result += symbol

    result += extension
    return result
